<?php

function avisos($form, &$form_state){
  global $user;
  global $base_path;
  $id_empleado = $user->uid;
  $name_empleado = $user->name;
  $u_admin = FALSE;
  $form = array();
  global $tipos_avisos;
  $tipos_avisos = array(
    1=>'DNI',
    2=>'Permiso de Conducir',
    3=>'Tarjeta Tacógrafo',
    4=>'CAP',
    5=>'Certificado de Puntos',
    6=>'IRPF',
    7=>'Certificado Delitos Sexuales',
    8=>'Alta Empleado',
    10=>'Otros'
  );
  //$id_empleado = user_load($user->uid);
  if (in_array('AdminEmpleados',$user->roles) || in_array('administrator',$user->roles)) $u_admin = TRUE;
  if (isset($_GET['empleado'])){
    if (!$u_empleado = user_load($_GET['empleado'])){
      drupal_set_message(t('Error en selección de Empleado.'),'error');
    }else{
      /*if (in_array('AdminEmpleados',$u_empleado->roles) && $user->uid != $u_empleado->uid){
        drupal_set_message(t('Empleado Seleccionado está Bloqueado, es Administrador'),'error');
      }else*/
      if (!$u_admin && $user->uid != $u_empleado->uid){
        //drupal_set_message(t('Sin acceso a otros usuarios.'),'error');
        $u_empleado = user_load($user->uid);
      }else{
        $id_empleado = $u_empleado->uid;
      }
    }
  }

  $menu = '<li><a href="'.$base_path.'empleados?empleado='.$id_empleado.'">Datos Personales</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/foto?empleado='.$id_empleado.'">Foto</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/dni?empleado='.$id_empleado.'">DNI</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/naf?empleado='.$id_empleado.'">NAF</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/pconducir?empleado='.$id_empleado.'">Permiso de Conducir</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/tach?empleado='.$id_empleado.'">Tarjeta Tacógrafo</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/cap?empleado='.$id_empleado.'">CAP</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certpuntos?empleado='.$id_empleado.'">Certificado de Puntos</a></li>';
  $menu .='<li><a href="#">Certificado Delitos Sexuales</a></li>';
  $menu .='<li><b><a href="'.$base_path.'empleados/avisos?empleado='.$id_empleado.'&sort=desc&order=ENVIADO">AVISOS</a></b></li>';
  if (in_array('administrator',$user->roles))
    $menu .='<li><b><a href="'.$base_path.'empleados/config">CONFIG</a></b></li>';

  $form['menudocumentos'] = array(
    '#type' => 'item',
    '#markup' => '<ul class="tabs secondary clearfix">'.$menu.'</ul>',
    '#weight' => -50,
  );
  if ($u_admin){
    $form['datos'] = array(
      '#type' => 'fieldset',
      '#title' => 'Enviar Aviso',
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['datos']['emp_sel'] = array(
      '#title' => 'Seleccione Empleado',
      '#description' => '<b><i>Si selecciona un empleado sólo se enviará el mensaje al empleado seleccionado.</i></b>',
      '#type' => 'textfield',
      '#autocomplete_path' => 'empleados/empleado_callback',
      '#size' => 60,
      '#attributes' => array(
        'placeholder' => t('Teclee EMPLEADO'),
        'autofocus' => true,
        'onfocus' => 'this.value =""',
      ),
    );
    $roles = array('4'=>'Conductor','5'=>'Oficina','7'=>'taller','10'=>'Monitoras');
		$form['datos']['seleccion-roles']=array(
			'#type' => 'checkboxes',
			'#title' => 'Seleccione Grupo',
			'#options' => $roles,
		);
		$form['datos']['seleccion-tipo']=array(
			'#type' => 'radios',
			'#title' => 'Seleccione Tipo',
			'#options' => $tipos_avisos,
      '#required'=> FALSE,
		);
    $form['datos']['texto']=array(
      '#type' => 'textarea',
      '#title' => 'Mensaje',
      //'#maxlength' => 200,
      '#description' => '<i>Teclee el mensaje a enviar.</i>',
      '#required'=> FALSE,
    );
    $form['datos']['boton-enviar'] = array(
      '#type' => 'submit',
      '#value' => 'Enviar Aviso',
      '#validate' =>array('_avisos_validate'),
      '#submit' =>array('_avisos_submit'),
    );
    $form['exp'] = array(
      '#type' => 'fieldset',
      '#title' => 'Exportar datos',
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['exp']['exportar'] = array(
      '#type' => 'submit',
      '#value' => t('Exportar Avisos a CSV'),
      '#submit' =>array('avisos_exportar'),
    );


  }

  $cabecera = array(
    array('data' => 'EMP.','field' => 'a.eid'),
    array('data' => 'TIPO','field' => 'a.tipo_aviso'),
    array('data' => 'ENVIADO','field' => 'a.fh_aviso'),
    array('data' => 'LEIDO','field' => 'a.fh_leido'),
    array('data' => 'TEXTO','field' => 'a.texto'),
  );
  $query = db_select('empleados_avisos','a');
  //$query->innerJoin('empleados','e','e.eid = a.eid');
  $query->innerJoin('users','u','u.uid = a.eid');
  $query->fields('a',array('eid','tipo_aviso','fh_aviso','fh_leido','texto'));
  $query->fields('u',array('name'));
  //if (!$u_admin) $query->condition('a.eid',$user->uid);
  $query->condition('a.eid',$id_empleado);
  $table_sort = $query->extend('TableSort')->orderByHeader($cabecera);
  $pager = $table_sort->extend('PagerDefault')->limit(10);
  $result = $pager->execute();
  $noleido = FALSE;
  $lista_avisos = array();
  foreach($result as $r){
    $nombre = obtenernombre($r->eid);
    $t_aviso = $tipos_avisos[$r->tipo_aviso];
    if (isset($r->fh_leido)){
      $leido = '<div style="text-align:center;"><img src="'.$base_path.'sites/default/files/iconos/avisoleido.png" alt="Leido" title="'.date('d-m-Y H:i',strtotime($r->fh_leido)).'" width="20" ></div>';
    }else{
      $leido = '<div style="text-align:center;"><img src="'.$base_path.'sites/default/files/iconos/avisonoleido.png" alt="NO Leido" title="NO Leido" width="20"></div>';
      if ($r->eid == $user->uid){
        $noleido = TRUE;
      }
    }
    $lista_avisos[] = array(
      '<span title="'.$nombre['nombre'].'">'.$r->name.'</span>',
      $t_aviso,
      date('d-m-Y H:i',strtotime($r->fh_aviso)),
      $leido,
      $r->texto
    );
  }
  $form['tabla'] = array(
    '#theme' => 'table',
    '#header' => $cabecera,
    '#rows' => $lista_avisos,
    '#empty' => t('No existen Avisos.'),
    '#weight' => 50,
    '#prefix' => '<div id="tabla-avisos" style="overflow-x:auto;">',
    '#suffix' => '<br><div>'
  ); 
		
	$form['pager'] = array(
	  '#theme' => 'pager',
		'#weight' => 51,
		'#suffix' => '<br>'
  );
  if ($noleido){
    $query = db_update('empleados_avisos')
      ->fields(array('fh_leido' => date('Y-m-d H:i:s')))
      ->condition('eid',$user->uid)
      ->condition('fh_leido',NULL)
    ->execute();
    drupal_set_message(t('Los mensajes pendientes se han marcado como LEIDOS.'),'warning');
  }
  
  return $form;
}

function _avisos_validate($form, &$form_state){
  if ($form_state['values']['emp_sel'] != ''){
    $empleado = explode('-',$form_state['values']['emp_sel']);
    $query = db_select('users','u')
      ->fields('u',array('uid'))
      ->condition('name',$empleado[0]);
    $res = $query->execute();
    if ($res->rowCount() == 0)
      form_set_error('emp_sel',t('Error en la selección de Empleado.'));
  }else{
    $sel_rol = FALSE;
    foreach ($form_state['values']['seleccion-roles'] as &$r){
      //drupal_set_message(t('@r',array('@r'=> $r)));
      if ($r > 0){
        
        $sel_rol = TRUE;
        break;
      }
    }
    if (!$sel_rol)
      form_set_error('seleccion-roles',t('Seleccione destino del Aviso.'));
  }
  if (!$form_state['values']['seleccion-tipo'])
    form_set_error('seleccion-tipo',t('Seleccione Tipo de Aviso.'));
  if ($form_state['values']['texto'] == '')
    form_set_error('texto',t('Rellene el texto del Aviso.'));
}

function _avisos_submit($form, &$form_state){
  global $tipos_avisos;
  $saltos   = array("\r\n", "\n", "\r");
  $texto = str_replace($saltos,'<br>',$form_state['values']['texto']);
  if ($form_state['values']['emp_sel'] != ''){
    $empleado = explode('-',$form_state['values']['emp_sel']);
    $query = db_select('users','u')
      ->fields('u',array('uid','mail'))
      ->condition('name',$empleado[0]);
    $res = $query->execute();
    foreach($res as $r){
      $eid = $r->uid;
      $mailto = $r->mail;
    }
    $query = db_insert('empleados_avisos')
      ->fields(array(
        'eid' => $eid,
        'tipo_aviso' => $form_state['values']['seleccion-tipo'],
        'fh_aviso' => date('Y-m-d H:i:s'),
        'texto' => $texto
      ))
    ->execute();
    $module = 'empleados';
    $key = 'aviso_libre';
    $from = NULL;
    $language = language_default();
    $params = array(
      'eid' => $eid,
      'tipo' => $tipos_avisos[$form_state['values']['seleccion-tipo']],
      'texto' => $texto,
    );
    $send = TRUE;
    $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
    if(!$result){
      drupal_set_message(t('Error al enviar email de aviso.'),'error');
    }
  }else{
    $or = '';
    foreach ($form_state['values']['seleccion-roles'] as &$r){
      if ($r>0){
        if ($or == ''){
          $or .= ' r.rid = '.$r;
        }else{
          $or .= ' OR r.rid = '.$r;
        }
        
      }
    }
    //drupal_set_message(t('OR @r',array('@r'=> $or)));
    $query = db_select('users','u');
    $query->innerJoin('users_roles','r','r.uid=u.uid');
    $query->innerJoin('empleados','e','e.eid=u.uid');
    $query->fields('u',array('uid','mail'));
    $query->where('(f_baja is NULL OR DATEDIFF(f_baja,CURRENT_DATE()>0)) AND ('.$or.')');
    $result = $query->execute();
    //drupal_set_message(t('@r',array('@r'=> $result->rowCount())));
    if ($result->rowCount()>0){
      $cco = '';
      $fh_aviso = date('Y-m-d H:i:s');
      foreach($result as $r){
        $query = db_insert('empleados_avisos')
        ->fields(array(
          'eid' => $r->uid,
          'tipo_aviso' => $form_state['values']['seleccion-tipo'],
          'fh_aviso' => $fh_aviso,
          'texto' => $texto,
        ))
        ->execute();
        if ($cco == ''){
          $cco .= $r->mail;
        }else{
          $cco .= ','.$r->mail;
        }
      }

      //drupal_set_message(t('@r',array('@r'=> $cco)));
      $module = 'empleados';
      $key = 'avisos_libres';
      $from = NULL;
      $mailto =  variable_get('site_mail', '');
      $language = language_default();
      $params = array(
        'eid' => 1,
        'tipo' => $tipos_avisos[$form_state['values']['seleccion-tipo']],
        'texto' => $texto,
        'cco' => $cco,
      );
      $send = TRUE;
      $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
      if(!$result){
        drupal_set_message(t('Error al enviar email de aviso.'),'error');
      }
    }
  }
}

function avisos_exportar($form, &$form_state){
  global $user;
  $tipos_avisos = array(
    1=>'DNI',
    2=>'Permiso de Conducir',
    3=>'Tarjeta Tacógrafo',
    4=>'CAP',
    5=>'Certificado de Puntos',
    6=>'IRPF',
    7=>'Certificado Delitos Sexuales',
    8=>'Alta Empleado',
    10=>'Otros'
  );
  $query = db_select('empleados_avisos','a');
  $query->join('empleados','e','a.eid=e.eid');
  $query->fields('e',array('nombre','apellidos','dni'));
  $query->fields('a',array('tipo_aviso','f_caduca','fh_aviso','fh_leido','texto'));
  $query->orderBy('a.id');
  $result = $query->execute();
  $rows = array();
  $rows[] = array('FH AVISO','TIPO AVISO','APELLIDOS','NOMBRE','DNI','FH LEIDO','FECHA DOCUMENTO CAD.','TEXTO ENVIADO');
  foreach ($result as $r){
    $salto = chr(10).chr(13);
    $texto = str_replace('<br>',$salto,$r->texto);
    $rows[] = array(
      $r->fh_aviso,
      utf8_decode($tipos_avisos[$r->tipo_aviso]),
      utf8_decode($r->apellidos),
      utf8_decode($r->nombre),
      $r->dni,
      $r->fh_leido,
      utf8_decode($texto)
    );
  }
  $nombre_fichero = 'ListadoAvisos-'.$user->uid.'-'.date('ymd_His').'.csv';
  //preparar el wrapper de salida
  $url_fichero = getcwd().'/sites/default/files/temp/'.$nombre_fichero;
  $outputBuffer = fopen($url_fichero, 'w');
   
  //volcamos el contenido del array en formato csv
  foreach($rows as $val) {
      fputcsv($outputBuffer, $val, ';');
  }
  //cerramos el wrapper
  fclose($outputBuffer);
  header('Content-Type: application/octet-stream');
  //header('Content-Transfer-Encoding: Binary'); 
  header('Content-disposition: inline; filename="'.$nombre_fichero.'"');
  readfile($url_fichero);
  unlink($url_fichero);
  exit();


}