<?php

function certpuntos($form, &$form_state){
  global $user;
  global $base_path;
  $id_empleado = $user->uid;
  $name_empleado = $user->name;
  $u_admin = FALSE;
  $form = array();

  if (in_array('AdminEmpleados',$user->roles) || in_array('administrator',$user->roles)) $u_admin = TRUE;
  if (isset($_GET['empleado'])){
    if (!$u_empleado = user_load($_GET['empleado'])){
      drupal_set_message(t('Error en selección de Empleado.'),'error');
    }else{
      /*if (in_array('AdminEmpleados',$u_empleado->roles) && $user->uid != $u_empleado->uid){
        drupal_set_message(t('Empleado Seleccionado está Bloqueado, es Administrador'),'error');
      }else*/if (!$u_admin && $user->uid != $u_empleado->uid){
        //drupal_set_message(t('Sin acceso a otros usuarios.'),'error');
        $u_empleado = user_load($user->uid);
      }else{
        $id_empleado = $u_empleado->uid;
      }
    }
  }

  $empleado = obtenernombre($u_empleado->uid);
  $name_empleado = $empleado['usuario'];


  $menu = '<li><a href="'.$base_path.'empleados?empleado='.$id_empleado.'">Datos Personales</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/foto?empleado='.$id_empleado.'">Foto</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/dni?empleado='.$id_empleado.'">DNI</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/naf?empleado='.$id_empleado.'">Tarjeta SS</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/pconducir?empleado='.$id_empleado.'">Permiso de Conducir</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/tach?empleado='.$id_empleado.'">Tarjeta Tacógrafo</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/cap?empleado='.$id_empleado.'">CAP</a></li>';
  $menu .='<li><a href="#">Certificado de Puntos</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certsex?empleado='.$id_empleado.'">Certificado Delitos Sexuales</a></li>';
  $menu .='<li><b><a href="'.$base_path.'empleados/avisos?empleado='.$id_empleado.'&sort=desc&order=ENVIADO">AVISOS</a></b></li>';
  if (in_array('administrator',$user->roles))
    $menu .='<li><b><a href="'.$base_path.'empleados/config">CONFIG</a></b></li>';

  $form['menudocumentos'] = array(
    '#type' => 'item',
    '#markup' => '<ul class="tabs secondary clearfix">'.$menu.'</ul>',
    '#weight' => -50,
  );
  if ($u_admin){
    $form['exp'] = array(
      '#type' => 'fieldset',
      '#title' => 'Exportar datos',
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
    $form['exp']['exportar'] = array(
      '#type' => 'submit',
      '#value' => t('Exportar datos a CSV'),
      '#submit' =>array('certpunt_exportar'),
    );
  }
  $form['datos'] = array(
    '#type' => 'fieldset',
    '#title' => 'Actualizar Certificado de puntos',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );


  $form['datos']['id'] = array(
    '#type' => 'hidden',
    //'#markup' =>$id_empleado,
    '#value' => $id_empleado,
  );
  $form['datos']['name'] = array(
    '#type' => 'item',
    //'#markup' =>$id_empleado,
    '#markup' => 'Usuario: <b>'.$name_empleado.'</b>',
  );

  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
	ftp_pasv($conn_id, TRUE);
	$ficheros = ftp_nlist($conn_id, '');

  $fotoftp = $id_empleado.'_certpunt.jpg';
  $foto = $user->uid.substr(str_shuffle("-_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 10).$id_empleado.'.jpg';
  //if (file_exists('private://'.$foto)) unlink('private://'.$foto);
  if (in_array($fotoftp,$ficheros)){
    $url_foto = $base_path.'sites/default/files/docs/'.$foto;
    //drupal_set_message(t('path: @p',array('@p'=>drupal_realpath('temporary://'.$foto))));
    ftp_get($conn_id, 'public://docs/'.$foto, $fotoftp, FTP_BINARY);

    $form['datos']['foto'] = array(
      '#type' => 'item',
      '#markup'=> '<a class="fancybox-effects-d" href="'.$url_foto.'" data-fancybox-group="Puntos" title="Certificado de Puntos DGT"><img src="'.$url_foto.'" alt="'.$id_empleado.'" title="Certificado de Puntos DGT" style="max-width:350px;"></a>',
    );
    
  }else{
    $form['datos']['textoayuda'] = array(
      '#type' => 'item',
      //'#markup' =>$id_empleado,
      '#markup' => '<i>No es necesario un certificado basta con una imagen del portal web de la DGT donde indica los puntos de los que disponemos.</i>',
    );
  }
  ftp_close($conn_id);

  $form['datos']['file'] = array(
        '#type' => 'file',
        '#title' => t('Imagen:'),
        '#description' => 'Seleccione imagen.<br />Sólo se permiten formatos "<strong>.jpg</strong>"',
  );


  $query = db_select('empleados_doc','d')
    ->fields('d',array('certpunt_fecha','certpunt_puntos','certpunt_uid_actualiza'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  $actualiza = NULL;
  $u_actualiza = 0;
  $puntos = '';
  foreach ($result as $q){
    $actualiza = $q->certpunt_fecha;
    $puntos = $q->certpunt_puntos;
    $u_actualiza = $q->certpunt_uid_actualiza;
  }

  $form['datos']['puntos'] = array(
    '#type' => 'textfield',
    '#title' => 'Puntos',
    '#description' => '<b><i>Actualice la cantidad de puntos coincidente con el certificado o imagen enviada.</i></b>',
    '#maxlength' => 2,
    '#size' => 2,
    '#required' => FALSE,
    '#default_value' => $puntos,
  );

  if (isset($actualiza)){
    $form['datos']['ult_actualiza'] = array(
      '#type' => 'item',
      '#markup' =>'<p>Última actualización: <b>'.date('d-m-Y',strtotime($actualiza)).'</b></p>',
    );
  }

  $form['datos']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Guardar Datos'),
    '#validate' => array('_certpuntos_validate'),
    '#submit' => array('_certpuntos_submit'),
  );

  return $form;
}

function _certpuntos_validate($form, &$form_state){
  $file = file_save_upload('file', array(
    'file_validate_extensions' => array('jpg'),
  ));
  if ($file) {
    if ($file = file_move($file, 'public://docs/up')) {
      $form_state['values']['file'] = $file;
    }
    else {
      form_set_error('file', t('Fallo al escribir el fichero en la carpeta site\'s.'));
    }
  }
  else {
    form_set_error('file', t('Fichero no actualizado.'));
  }
  if(!is_numeric($form_state['values']['puntos']))
    form_set_error('puntos', t('Teclee un valor numérico en el campo "Puntos".'));
}

function _certpuntos_submit($form, &$form_state){
  global $user;
  $file=$form_state['values']['file'];
  unset($form_state['values']['file']);
  $file->status = FILE_STATUS_PERMANENT;
  file_save($file);
  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 

  // iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
  ftp_pasv($conn_id,TRUE);
  $fotoftp = $form_state['values']['id'].'_certpunt.jpg';
  ftp_put($conn_id, $fotoftp, $file->uri, FTP_BINARY);
  ftp_close($conn_id);

  $query = db_delete('file_managed')
    ->condition('uid',$user->uid)
    ->condition('filename',$file->filename)
    ->condition('status',1)
     ->execute();
  drupal_set_message(t('Imagen actualizada correctamente.'));

  $id_empleado = $form_state['values']['id'];
  $query = db_select('empleados_doc','e')
    ->fields('e', array('certpunt_fecha'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  if ($result->rowCount() > 0){
    $query = db_update('empleados_doc')
      ->fields(array(
        'certpunt_uid_actualiza' => $user->uid,
        'certpunt_puntos' => $form_state['values']['puntos'],
        'certpunt_fecha' => date('Y-m-d'),
      ))
      ->condition('eid',$id_empleado)
    ->execute();
  }else{
    $query = db_insert('empleados_doc')
      ->fields(array(
        'eid' => $id_empleado,
        'certpunt_uid_actualiza' => $user->uid,
        'certpunt_puntos' => $form_state['values']['puntos'],
        'certpunt_fecha' => date('Y-m-d'),
      ))
    ->execute();
  }

  $query = db_select('empleados_config','e')
  ->fields('e',array('mail_certpunt'));
  $result=$query->execute();
  foreach($result as $r){
    $to = $r->mail_certpunt;
  }
  $mailto = str_replace(' ','',$to);
  $module = 'empleados';
  $key = 'certpunt_actualizado';
  $from = NULL;
  $language = language_default();
  $params = array(
    'imagen' => $file->filename,
    'eid' => $id_empleado,
    'puntos' => $form_state['values']['puntos'],
  );
  $send = TRUE;
  $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
  if($result){
    drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
  }else{
    drupal_set_message(t('Error al avisar al administrador del cambio del Certificado de Puntos.'),'error');
  }

  unlink($file->uri);
}

function certpunt_exportar($form, $form_state){
  global $user;
  $query = db_select('empleados_doc','d');
  $query->join('empleados','e','d.eid=e.eid');
  $query->join('users_roles','r','d.eid=r.uid');
  $query->join('users','u','u.uid=d.eid');
  $query->fields('e',array('nombre','apellidos','dni'));
  $query->fields('d',array('certpunt_fecha','certpunt_puntos'));
  $query->condition('rid',4);
  $query->condition('status',1);
  $query->orderBy('apellidos');
  $query->orderBy('nombre');
  $result = $query->execute();
  $rows = array();
  $rows[] = array('APELLIDOS','NOMBRE','DNI',utf8_decode('FECHA ACTUALIZACIÓN'),'PUNTOS');
  foreach ($result as $r){
    $rows[] = array(utf8_decode($r->apellidos),utf8_decode($r->nombre),$r->dni,$r->certpunt_fecha,$r->certpunt_puntos);
  }
  $nombre_fichero = 'ListadoPuntos-'.$user->uid.'-'.date('ymd_His').'.csv';
  //preparar el wrapper de salida
  $url_fichero = getcwd().'/sites/default/files/temp/'.$nombre_fichero;
  $outputBuffer = fopen($url_fichero, 'w');
   
  //volcamos el contenido del array en formato csv
  
  foreach($rows as $val) {
      fputcsv($outputBuffer, $val, ';');
  }
  //cerramos el wrapper
  fclose($outputBuffer);
  header('Content-Type: application/octet-stream');
  //header('Content-Transfer-Encoding: Binary'); 
  header('Content-disposition: inline; filename="'.$nombre_fichero.'"');
  readfile($url_fichero);
  unlink($url_fichero);
  exit();


}