<?php

function config($form, &$form_state){
  $form = array();
  $maildni ='';
  $mailcc ='';
  $mailirpf ='';
  $mailpc ='';
  $mailtach ='';
  $mailcertpunt ='';
  $mailcertsex ='';

  $query = db_select('empleados_config','e')
    ->fields('e',array('mail_dni','mail_cc','mail_irpf','mail_pconducir','mail_tach','mail_certpunt','mail_certsex'));
  $result = $query->execute();
  foreach($result as $r){
    $maildni = $r->mail_dni;
    $mailcc = $r->mail_cc;
    $mailirpf = $r->mail_irpf;
    $mailpc = $r->mail_pconducir;
    $mailtach = $r->mail_tach;
    $mailcertpunt = $r->mail_certpunt;
    $mailcertsex = $r->mail_certsex;
  }
  $form['srv'] = array(
    '#type'          => 'textfield',
    '#title'         => t('Servidor IP'),
    '#default_value' => variable_get('emp_ftp_srv', ''),
    '#description'   => t('La direcci&oacuten IP del servidor de datos FTP.'),
    '#required'      => TRUE,
  );
	$form['port'] = array(
    '#type'          => 'textfield',
    '#title'         => t('Puerto'),
    '#size'          => 6,
    '#maxlength'     => 6,
    '#default_value' => variable_get('emp_ftp_port', '21'),
    '#description'   => t('El puerto FTP del servidor de datos, por defecto 21.'),
  );
	$form['usr'] = array(
    '#type'          => 'textfield',
    '#title'         => t('Usuario'),
    '#default_value' => variable_get('emp_ftp_usr', ''),
    '#description'   => t('Nombre de usuario para conectar con FTP.'),
    '#required'      => TRUE,
  );
	$form['pwd'] = array(
    '#type'          => 'password',
    '#title'         => t('Clave de usuario'),
    '#default_value' => variable_get('emp_ftp_pwd', ''),
    '#description'   => t('Clave de usuario para conectar con FTP.'),
    //'#required'      => TRUE,
  );

  $form['maildni'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso DNI',
		'#default_value' => $maildni,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['mailcc'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso Domiciliación Bancaria',
		'#default_value' => $mailcc,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['mailirpf'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso IRPF',
		'#default_value' => $mailirpf,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['mailpc'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso Permiso Conducir',
		'#default_value' => $mailpc,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['mailtach'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso Tarjeta Tacógrafo',
		'#default_value' => $mailtach,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['mailcertpunt'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso Certificado de Puntos',
		'#default_value' => $mailcertpunt,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['mailcertsex'] = array(
		'#type' => 'textarea',
		'#title' => 'Email aviso Certificado Delitos Sexuales',
		'#default_value' => $mailcertsex,
		'#disabled' => FALSE,
		'#required' => FALSE,
		'#description' => 'Separe con (<b>,</b>) si desea escribir m&aacute;s de un email.',
	);
  $form['submit'] = array(
		'#type'          => 'submit',
		'#value'         => 'Guardar Datos',
		//'#submit'        => array('mensajes_btk_config_submit'),
		);

  return $form;
}

function config_submit($form, &$form_state){
  
  $query = db_delete('empleados_config')->execute();

  $query = db_insert('empleados_config')
    ->fields(array(
      'mail_dni' => $form_state['values']['maildni'],
      'mail_cc' => $form_state['values']['mailcc'],
      'mail_irpf' => $form_state['values']['mailirpf'],
      'mail_pconducir' => $form_state['values']['mailpc'],
      'mail_tach' => $form_state['values']['mailtach'],
      'mail_certpunt' => $form_state['values']['mailcertpunt'],
      'mail_certsex' => $form_state['values']['mailcertsex']
    ))
    ->execute();
  variable_set('emp_ftp_srv',$form_state['values']['srv']);
  variable_set('emp_ftp_port',$form_state['values']['port']);
  variable_set('emp_ftp_usr',$form_state['values']['usr']);
  if ($form_state['values']['pwd'] != ''){
    variable_set('emp_ftp_pwd',$form_state['values']['pwd']);
  }
  variable_set('emp_config',1);
  drupal_set_message(t('Datos Guardados'));
  $form_state['redirect'] = array('empleados');
}