<?php

function datospersonales($form, &$form_state){

  global $user;
  global $base_path;
  $form = array();
  $u_admin = FALSE;
  $id_empleado = $user->uid;

  if (in_array('AdminEmpleados',$user->roles) || in_array('administrator',$user->roles)) $u_admin = TRUE;
  if ($u_admin && isset($_GET['empleado'])) {
    if (!$u_empleado = user_load($_GET['empleado'])){
      drupal_set_message(t('Error en selección de Empleado.'),'error');
    }else{
      /*if (in_array('AdminEmpleados',$u_empleado->roles) && $user->uid != $u_empleado->uid){
        drupal_set_message(t('Empleado Seleccionado está Bloqueado, es Administrador'),'error');
      }else{*/
        $id_empleado = $u_empleado->uid;
      //}
    }
  }

  if ($u_admin){
    if (variable_get('emp_config',0) == 0) drupal_set_message(t('Acceda al apartado configuración'),'warning');

    /*BUSCAMOS NUEVOS USUARIOS AÑADIDOS y los damos de alta en empleados*/
    $query = db_select('users','u')
    ->fields('u',array('uid','name'))
    ->where('not EXISTS (select eid FROM empleados where uid=eid)');
    $result = $query->execute();
    if ($result->rowCount() > 0){
      foreach ($result as $r){
        $q = db_insert('empleados')
        ->fields(array(
          'eid' => $r->uid,
          'nombre' => $r->name,
          'f_altadatos' => date('Y-m-d'),
        ))
        ->execute();
      }
    }

    $form['fs_busca_emp'] = array(
      '#type' => 'fieldset',
      '#title' => 'Seleccionar Empleado',
      '#collapsible' => TRUE,
      '#collapsed' => TRUE,
    );
  
    $form['fs_busca_emp']['empleado_sel'] = array(
      '#type' => 'textfield',
      '#autocomplete_path' => 'empleados/empleado_callback',
      '#size' => 60,
      '#ajax' => array(
        'callback' => 'ajax_boton_empleado',
        'wrapper' => 'boton-empleado',
        'progress' => array('type' => 'none'),
      ),
      '#attributes' => array(
        'placeholder' => t('Teclee EMPLEADO'),
        'autofocus' => true,
        'onfocus' => 'this.value =""',
      ),
    );
		$form['fs_busca_emp']['boton_emp']=array(
			'#type' => 'submit',
			'#value' => 'Seleccione Empleado',
			'#submit' => array('_mostrar_empleado'),
			'#prefix' => '<div id="boton-empleado">',
			'#suffix' => '</div>',
			'#disabled' => true,
		);

    if (!empty($form_state['values']['empleado_sel'])){
      $form['fs_busca_emp']['boton_emp']['#value'] = "Editar Empleado Seleccionado";
      $form['fs_busca_emp']['boton_emp']['#disabled'] = false;
    }
	
	
        /*if ($id_empleado > 0){
            $query = db_select()
        }*/
  }
  $query = db_select('empleados','e');
  $query->join('users','u','uid = eid');
  $query->fields('e',array('nombre','apellidos','dni','naf','f_nacimiento','direccion','poblacion','provincia','cp','t_fijo','t_movil','estudios','cc_iban','cc_entidad','cc_oficina','cc_dc','cc_cuenta','irpf','f_altadatos','f_ultmodif','uid_modifdatos','f_baja'));
  $query->fields('u',array('name','mail'));
  $query->condition('eid',$id_empleado);
  $result = $query->execute();
  
  $nombre = '';
  $apellidos ='';
  $dni = '';
  $naf = '';
  $fecha = NULL;
  $direccion = '';
  $poblacion = '';
  $provincia = '';
  $cp = '';
  $fijo = '';
  $movil = '';
  $estudios = '';
  $iban = '';
  $entidad = '';
  $oficina = '';
  $dc = '';
  $cuenta = '';
  $irpf = '';
  $f_modif = NULL;
  $uid_modif = 0;
  $f_baja = NULL;
  $name = '';
  $email = '';
  foreach ($result as $q){
    $nombre = $q->nombre;
    $apellidos = $q->apellidos;
    $dni = $q->dni;
    $naf = $q->naf;
    $fecha = $q->f_nacimiento;
    $direccion = $q->direccion;
    $poblacion = $q->poblacion;
    $provincia = $q->provincia;
    $cp = str_pad($q->cp, 5, "0", STR_PAD_LEFT);
    $fijo = $q->t_fijo;
    $movil = $q->t_movil;
    $estudios = $q->estudios;
    $iban = $q->cc_iban;
    $entidad = $q->cc_entidad;
    $oficina = $q->cc_oficina;
    $dc = $q->cc_dc;
    $cuenta = $q->cc_cuenta;
    $irpf = $q->irpf;
    $f_modif = $q->f_ultmodif;
    $uid_modif = $q->uid_modifdatos;
    $f_baja = $q->f_baja;
    $name = $q->name;
    $email = $q->mail;
  }

	//$ftp_user_name = 'docs_empleados';
	//$ftp_user_pass = 'C3vesa!2021';
  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 

	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
	ftp_pasv($conn_id, TRUE);
	$ficheros = ftp_nlist($conn_id, '');

  $menu = '<li><a href="#">Datos Personales</a></li>';
  $menu .= '<li><a href="'.$base_path.'empleados/foto?empleado='.$id_empleado.'">Foto</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/dni?empleado='.$id_empleado.'">DNI</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/naf?empleado='.$id_empleado.'">Tarjeta SS</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/pconducir?empleado='.$id_empleado.'">Permiso de Conducir</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/tach?empleado='.$id_empleado.'">Tarjeta Tacógrafo</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/cap?empleado='.$id_empleado.'">CAP</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certpuntos?empleado='.$id_empleado.'">Certificado de Puntos</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certsex?empleado='.$id_empleado.'">Certificado Delitos Sexuales</a></li>';
  $menu .='<li><b><a href="'.$base_path.'empleados/avisos?empleado='.$id_empleado.'&sort=desc&order=ENVIADO">AVISOS</a></b></li>';
  if (in_array('administrator',$user->roles))
    $menu .='<li><b><a href="'.$base_path.'empleados/config">CONFIG</a></b></li>';

  $form['menudocumentos'] = array(
    '#type' => 'item',
    '#markup' => '<ul class="tabs secondary clearfix">'.$menu.'</ul>',
    '#weight' => -50,
  );

  $form['datos'] = array(
    '#type' => 'fieldset',
    '#title' => 'Datos Personales',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );

  $form['datos']['id'] = array(
    '#type' => 'hidden',
    //'#markup' =>$id_empleado,
    '#value' => $id_empleado,
  );
  
  if ($u_admin) {
    //$u_acualiza = user_load($uid_modif);
    $actualizador = obtenernombre($uid_modif);
    $form['datos']['modif'] = array(
      '#type' => 'item',
      '#markup'=> '<p><i>Fecha actualización: <b>'.date('d-m-Y',strtotime($f_modif)).'</b></i></br>
                <i>Actualizado por: '.$actualizador['usuario'].'</i></p>',
    );
  }
  $fotoftp = $id_empleado.'_foto.jpg';
  $foto = $user->uid.substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 10).$id_empleado.'.jpg';
  //if (file_exists('private://'.$foto)) unlink('private://'.$foto);
  if (in_array($fotoftp,$ficheros)){
    global $conf;
    $url_foto = $conf["file_public_path"].'/docs/'.$foto;
    //drupal_set_message(t('path: @p',array('@p'=>drupal_realpath('temporary://'.$foto))));
    ftp_get($conn_id, 'public://docs/'.$foto, $fotoftp, FTP_BINARY);
    //$url_foto = getcwd().'/'.$conf["file_public_path"].'/'.$foto;
    $form['datos']['foto'] = array(
      '#type' => 'item',
      '#markup'=> '<a href="empleados/foto?empleado='.$id_empleado.'"><img src="'.$url_foto.'" alt="'.$id_empleado.'" title="Cambiar Foto de Emleado" style="max-width:250px;"></a>',
    );
    
  }

/*  $form['datos']['fotoimg'] = array(
    '#type' => 'file',
    '#title' => 'Imagen de Empleado',
    '#description' => 'Seleccione una imagen "<strong>.jpg</strong>"',
  );*/

  $form['datos']['nombre'] = array(
    '#type' => 'textfield',
    '#title' => 'Nombre <span class="form-required" title="Este campo es obligatorio.">*</span>',
    '#maxlength' => 50,
    '#size' => 42,
    '#default_value' => $nombre,
    '#disabled' => !$u_admin,
  );
  $form['datos']['apellidos'] = array(
    '#type' => 'textfield',
    '#title' => 'Apellidos <span class="form-required" title="Este campo es obligatorio.">*</span>',
    '#maxlength' => 50,
    '#size' => 42,
    '#default_value' => $apellidos,
    '#disabled' => !$u_admin,
  );
  $form['datos']['dni'] = array(
    '#type' => 'textfield',
    '#title' => 'DNI <span class="form-required" title="Este campo es obligatorio.">*</span>',
    '#maxlength' => 9,
    '#size' => 10,
    '#default_value' => $dni,
    '#description' => 'Ejemplo: 78234123H',
    '#disabled' => !$u_admin,
  );
  $form['datos']['naf'] = array(
    '#type' => 'textfield',
    '#title' => 'Número Afiliazión S.S.',
    '#maxlength' => 12,
    '#size' => 15,
    '#required' => FALSE,
    '#default_value' => $naf,
    '#disabled' => !$u_admin,
  );
  $format = 'd-m-Y';
  $form['datos']['fecha'] = array(
    '#type' => 'date_popup',
    '#title' => t('Fecha Nacimiento'),
    '#default_value' => $fecha, 
    '#date_format' => $format,
    '#size' => 12,
    '#date_label_position' => 'within',
    '#date_year_range' => '-70:+3',
    //'#required' => TRUE,
    '#disabled' => !$u_admin,
  );
  $form['datos']['direccion'] = array(
    '#type' => 'textfield',
    '#title' => 'Dirección',
    '#maxlength' => 70,
    '#size' => 42,
    '#required' => FALSE,
    '#default_value' => $direccion,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['poblacion'] = array(
    '#type' => 'textfield',
    '#title' => 'Población',
    '#maxlength' => 35,
    '#size' => 30,
    '#required' => FALSE,
    '#default_value' => $poblacion,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['provincia'] = array(
    '#type' => 'textfield',
    '#title' => 'Provincia',
    '#maxlength' => 25,
    '#size' => 25,
    '#required' => FALSE,
    '#default_value' => $provincia,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['cp'] = array(
    '#type' => 'textfield',
    '#title' => 'Código Postal',
    '#maxlength' => 5,
    '#size' => 5,
    '#required' => FALSE,
    '#default_value' => $cp,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['fijo'] = array(
    '#type' => 'textfield',
    '#title' => 'Tlfno. Fijo',
    '#maxlength' => 9,
    '#size' => 9,
    '#required' => FALSE,
    '#default_value' => $fijo,
    //'#disabled' => !$u_admin,
  );

  $form['datos']['movil'] = array(
    '#type' => 'textfield',
    '#title' => 'Tlfno. Móvil',
    '#maxlength' => 9,
    '#size' => 9,
    '#required' => FALSE,
    '#default_value' => $movil,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['email'] = array(
    '#type' => 'textfield',
    '#title' => 'Correo Electrónico',
    '#maxlength' => 254,
    '#size' => 40,
    '#required' => FALSE,
    '#default_value' => $email,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['estudios'] = array(
    '#type' => 'textarea',
    '#title' => 'Estudios',
    '#maxlength' => 100,
    '#default_value' => $estudios,
    //'#disabled' => !$u_admin,
  );
  $form['datos']['cc'] = array(
    '#type' => 'fieldset',
    '#title' => 'Domiciliación Bancaria',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );

  $form['datos']['cc']['iban'] = array(
    '#prefix' => '<div style="max-width: 100px; float:left;margin:5px;">',
    '#suffix' => '</div>',
    '#type' => 'textfield',
    '#title' => 'IBAN',
    '#maxlength' => 4,
    '#size' => 4,
    '#default_value' => $iban,
  );
  $form['datos']['cc']['ent'] = array(
    '#prefix' => '<div style="max-width: 100px; float:left;margin:5px;">',
    '#suffix' => '</div>',
    '#type' => 'textfield',
    '#title' => 'Entidad',
    '#maxlength' => 4,
    '#size' => 4,
    '#default_value' => $entidad,
  );
  $form['datos']['cc']['oficina'] = array(
    '#prefix' => '<div style="max-width: 100px; float:left;margin:5px;">',
    '#suffix' => '</div>',
    '#type' => 'textfield',
    '#title' => 'Oficina',
    '#maxlength' => 4,
    '#size' => 4,
    '#default_value' => $oficina,
  );
  $form['datos']['cc']['dc'] = array(
    '#prefix' => '<div style="max-width: 100px; float:left;margin:5px;">',
    '#suffix' => '</div>',
    '#type' => 'textfield',
    '#title' => 'DC',
    '#maxlength' => 2,
    '#size' => 1,
    '#default_value' => $dc,
  );
  $form['datos']['cc']['cuenta'] = array(
    '#prefix' => '<div style="max-width: 150px; float:left;margin:5px;">',
    '#suffix' => '</div>',
    '#type' => 'textfield',
    '#title' => 'Número de Cuenta',
    '#maxlength' => 10,
    '#size' => 10,
    '#default_value' => $cuenta,
  );
  $form['datos']['cc']['btn_irpf'] = array(
    '#type' => 'submit',
    '#value' => 'Guardar CC',
    '#submit' => array('_guardar_cc'),
    '#validate' => array('_valida_cc'),
  );

  $form['datos']['ir'] = array(
    '#type' => 'fieldset',
    '#title' => 'IRPF',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );
  
  $form['datos']['ir']['irpf'] = array(
    '#type' => 'textfield',
    '#title' => 'Retención IRPF',
    '#description' => '<b><i>Porcentaje de retención a cuenta del Impuesto sobre la Renta de Personas Física.<br>
                          No se permiten valores inferiores a 6.<br>
                          Si se deja vacío el sistema calculará de forma automática la retención.</i></b>',
    '#maxlength' => 2,
    '#size' => 2,
    '#required' => FALSE,
    '#default_value' => $irpf,
  );
  $form['datos']['ir']['btn_irpf'] = array(
    '#type' => 'submit',
    '#value' => 'Guardar IRPF',
    '#submit' => array('_guardar_irpf'),
    '#validate' => array('_valida_irpf'),
  );
  if ($u_admin){  
    $form['datos']['fecha_baja'] = array(
      '#type' => 'date_popup',
      '#title' => t('Fecha de Baja'),
      '#default_value' => $f_baja, 
      '#date_format' => $format,
      '#size' => 12,
      '#date_label_position' => 'within',
      '#date_year_range' => '-5:+5',
      //'#required' => TRUE,
      //'#disabled' => !$u_admin,
    );
  
  }
  $form['datos']['btn_datos'] = array(
    '#type' => 'submit',
    '#value' => 'Guardar Todos los Datos',
    '#submit' => array('_guardar_datos'),
    '#validate' => array('_valida_datos'),
  );

  return $form;
}

function sel_empleado_autocomplete($string){
  $matches = array();
  $or = db_or();
  $or->condition('u.name','%'. db_like($string) . '%','LIKE');
  $or->condition('e.nombre','%'. db_like($string) . '%','LIKE');
  $or->condition('e.apellidos','%'. db_like($string) . '%','LIKE');
  $query = db_select('users','u');
  $query->join('empleados','e','u.uid = e.eid');
  $query->distinct();
  $query->orderBy('name');
  $query->fields('u',array('uid','name'));
  $query->fields('e',array('nombre','apellidos'));
  //$query->condition('u.name', '%'. db_like($string) . '%','LIKE');
  //$query->where('(f_baja is NULL OR DATEDIFF(f_baja,CURRENT_DATE()>0))');
  $query->condition($or);
  $result = $query->execute();
  foreach ($result as $row){
    $matches[$row->name.' - '.$row->nombre.' '.$row->apellidos] = $row->name.' - '.$row->nombre.' '.$row->apellidos;
    //$matches[$row->uid.'-'.$row->name] = check_plain($row->name);
  }
  drupal_json_output($matches);
}

function ajax_boton_empleado($form,&$form_state){
	return $form['fs_busca_emp']['boton_emp'];
}

function _mostrar_empleado($form,&$form_state){
  $empleado = explode('-',$form_state['values']['empleado_sel']);
  $query = db_select('users','u')
    ->fields('u',array('uid'))
    ->condition('name',$empleado[0]);
  $res = $query->execute();
  foreach($res as $r){
    $eid = $r->uid;
  }
  $form_state['redirect'] = array('empleados',array('query' => array('empleado' => $eid)));
}


function _valida_cc($form,&$form_state){
  $iban = $form_state['values']['iban'];
  $entidad = $form_state['values']['ent'];
  $oficina = $form_state['values']['oficina'];
  $dc = $form_state['values']['dc'];
  $cuenta = $form_state['values']['cuenta'];
  $error = FALSE;

  if (strlen($iban) == 4){
    if (!is_string(substr($iban,0,2))){
      form_set_error('iban',t('El código <b>IBAN</b> es incorrecto'));
      $error = TRUE;
    } 
    if (!is_numeric(substr($iban,2,2))) {
      form_set_error('iban',t('El código <b>IBAN</b> es incorrecto'));
      $error = TRUE;
    }
  }else{
    form_set_error('iban',t('El código <b>IBAN</b> tiene que ser de 2 letras y 2 números'));
    $error = TRUE;
  }

  if (strlen($entidad) != 4 || !is_numeric($entidad)){
    form_set_error('ent',t('El código <b>Entidad</b> es incorrecto'));
    $error = TRUE;
  }
  if (strlen($oficina) != 4 || !is_numeric($oficina)){
    form_set_error('oficina',t('El código <b>Oficina</b> es incorrecto'));
    $error = TRUE;
  }
  if (strlen($dc) != 2 || !is_numeric($dc)) {
    form_set_error('dc',t('El código <b>DC</b> es incorrecto'));
    $error = TRUE;
  }
  if (strlen($cuenta) != 10 || !is_numeric($cuenta)) {
    form_set_error('cuenta',t('El código <b>Número de Cuenta</b> es incorrecto'));
    $error = TRUE;
  }
  if (!$error){
    $v = intval(substr($entidad,0,1))*4;
    $v += intval(substr($entidad,1,1))*8;
    $v += intval(substr($entidad,2,1))*5;
    $v += intval(substr($entidad,3,1))*10;
    
    $v += intval(substr($oficina,0,1))*9;
    $v += intval(substr($oficina,1,1))*7;
    $v += intval(substr($oficina,2,1))*3;
    $v += intval(substr($oficina,3,1))*6;
    
    $dc1 = 11-fmod($v,11);
    if($dc1 == 10) $dc1 = 1;
    if($dc1 == 11) $dc1 = 0;

    $v = intval(substr($cuenta,0,1))*1;
    $v += intval(substr($cuenta,1,1))*2;
    $v += intval(substr($cuenta,2,1))*4;
    $v += intval(substr($cuenta,3,1))*8;
    $v += intval(substr($cuenta,4,1))*5;
    $v += intval(substr($cuenta,5,1))*10;
    $v += intval(substr($cuenta,6,1))*9;
    $v += intval(substr($cuenta,7,1))*7;
    $v += intval(substr($cuenta,8,1))*3;
    $v += intval(substr($cuenta,9,1))*6;

    $dc2 = 11-fmod($v,11);
    if($dc2 == 10) $dc2 = 1;
    if($dc2 == 11) $dc2 = 0;
    //drupal_set_message(t('dc = @d',array('@d'=> $dc1.$dc2)));
    if ($dc != $dc1.$dc2){
      form_set_error('ent',t('Error general en cuenta'));
      form_set_error('oficina',t(''));
      form_set_error('dc',t(''));
      form_set_error('cuenta',t(''));
    }/*else{ 
      if(strtoupper(substr($iban,0,2)) == 'ES'){
        $v = ($entidad.$oficina.$dc.$cuenta.'142800' % 97);
        //$v = 98-(146512344612345678901428 % 97);
        drupal_set_message(t('cuenta = @d',array('@d'=> $entidad.$oficina.$dc.$cuenta.'142800')));
        drupal_set_message(t('dciban = @d',array('@d'=> $v)));
        $dciban = str_repeat('0',2-strlen($v)).$v;
        if(substr($iban,2,2) != $dciban) form_set_error('iban',t('Error en código <b>IBAN</b>'));
      }
    }*/
  }

}

function _guardar_cc($form,&$form_state){
  $eid = $form_state['values']['id'];
  $iban = strtoupper($form_state['values']['iban']);
  $ent = $form_state['values']['ent'];
  $oficina = $form_state['values']['oficina'];
  $dc = $form_state['values']['dc'];
  $cuenta = $form_state['values']['cuenta'];

  $query = db_select('empleados','e')
    ->fields('e',array('cc_iban','cc_entidad','cc_oficina','cc_dc','cc_cuenta'))
    ->condition('eid',$eid);
  $result=$query->execute();
  
  global $user;
  
  $cc_actualizada = FALSE;
  if ($result->rowCount() > 0){
    foreach($result as $r){
      if($iban != $r->cc_iban ||
        $ent != $r->cc_entidad ||
        $oficina != $r->cc_oficina ||
        $dc != $r->cc_dc ||
        $cuenta != $r->cc_cuenta)
        $cc_actualizada = TRUE;
    }
    if ($cc_actualizada){
      $qupdate = db_update('empleados')
        ->fields(array(
          'cc_iban' => $iban,
          'cc_entidad' => $ent,
          'cc_oficina' => $oficina,
          'cc_dc' => $dc,
          'cc_cuenta' => $cuenta,
          'uid_modifdatos' => $user->uid,
          'f_ultmodif' => date('Y-m-d'),
        ))
        ->condition('eid',$eid)
        ->execute();
    }else{
      drupal_set_message(t('El número de cuenta es el mismo. NO ha sido actualizado.'),'warning');
      return;
    }
  }else{
    $qinsert = db_insert('empleados')
      ->fields(array(
        'eid' => $eid,
        'cc_iban' => $iban,
        'cc_entidad' => $ent,
        'cc_oficina' => $oficina,
        'cc_dc' => $dc,
        'cc_cuenta' => $cuenta,
        'uid_modifdatos' => $user->uid,
        'f_ultmodif' => date('Y-m-d'),
      ))
      ->execute();
  }
  $query = db_select('empleados_config','e')
  ->fields('e',array('mail_cc'));
  $result=$query->execute();
  foreach($result as $r){
    $to = $r->mail_cc;
  }
  $u_empleado = user_load($eid);
  $mailto = str_replace(' ','',$to);
  $module = 'empleados';
  $key = 'cc_actualizada';
  $from = $u_empleado->mail;
  $language = language_default();
  $params = array(
    'eid' => $eid,
    'cc_iban' => $iban,
    'cc_entidad' => $ent,
    'cc_oficina' => $oficina,
    'cc_dc' => $dc,
    'cc_cuenta' => $cuenta
  );
  $send = TRUE;
  drupal_set_message(t('El número de Cuenta Corriente ha sido actualizado.'));
  $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
  if($result){
    drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
  }else{
    drupal_set_message(t('Error al avisar al administrador del cambio de Cuenta. Avise a la oficina para que tengan en cuenta el cambio.'),'error');
  }
}


function _valida_irpf($form,&$form_state){
  $irpf = $form_state['values']['irpf'];
  if ($irpf != ''){
    if (!is_numeric($irpf)){
      form_set_error('irpf',t('El <b>IRPF</b> tiene que ser numérico.'));
      return;
    }
    if (intval($irpf) < 6){
      form_set_error('irpf',t('El <b>IRPF</b> tiene que ser igual o mayor de <b>6</b>.'));
    }
    if (intval($irpf) > 70){
      form_set_error('irpf',t('El <b>IRPF</b> tiene que ser menor de 50.'));
    }
  }
}

function _guardar_irpf($form,&$form_state){
  $eid = $form_state['values']['id'];
  $irpf = $form_state['values']['irpf'];

  $query = db_select('empleados','e')
    ->fields('e',array('irpf'))
    ->condition('eid',$eid);
  $result=$query->execute();
  
  global $user;
  
  $irpf_actualizado = FALSE;
  if ($result->rowCount() > 0){
    foreach($result as $r){
      if($irpf != intval($r->irpf)) $irpf_actualizado = TRUE;
    }
    if ($irpf_actualizado){
      $qupdate = db_update('empleados')
        ->fields(array(
          'irpf' => $irpf,
          'uid_modifdatos' => $user->uid,
          'f_ultmodif' => date('Y-m-d'),
        ))
        ->condition('eid',$eid)
        ->execute();
    /*}else{
      drupal_set_message(t('El número de cuenta es el mismo. NO ha sido actualizado.'),'warning');
      return;*/
    }
  }else{
    $qinsert = db_insert('empleados')
      ->fields(array(
        'eid' => $eid,
        'irpf' => $irpf,
        'uid_modifdatos' => $user->uid,
        'f_ultmodif' => date('Y-m-d'),
      ))
      ->execute();
  }
  $query = db_select('empleados_config','e')
  ->fields('e',array('mail_irpf'));
  $result=$query->execute();
  foreach($result as $r){
    $to = $r->mail_irpf;
  }
  $u_empleado = user_load($eid);
  //drupal_set_message(t('@m',array('@m'=>$u_empleado->mail)));
  $mailto = str_replace(' ','',$to);
  $module = 'empleados';
  $key = 'irpf_actualizado';
  $from = $u_empleado->mail;
  $language = language_default();
  $params = array(
    'eid' => $eid,
    'irpf' => $irpf,
  );
  $send = TRUE;
  drupal_set_message(t('El IRPF ha sido actualizado.'));
  $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
  if($result){
    drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
  }else{
    drupal_set_message(t('Error al avisar al administrador del cambio de IRPF. Avise a la oficina para que tengan en cuenta el cambio.'),'error');
  }
}

function _valida_datos($form,&$form_state){
  if (strlen($form_state['values']['nombre']) <= 0) form_set_error('nombre',t('Rellene el <b>Nombre</b>.'));
  if (strlen($form_state['values']['apellidos']) <= 0) form_set_error('apellidos',t('Rellene los <b>Apellidos</b>.'));
  $dni = strtoupper($form_state['values']['dni']);
  //drupal_set_message(t('dni: !d',array('!d'=>$dni)));
  $nie = substr($dni,0,1);
  //drupal_set_message(t('nie: @d',array('@d'=>$nie)));
  $l = substr($dni,-1);
  //drupal_set_message(t('l: @d',array('@d'=>$l)));
  if(is_numeric($l)){
    form_set_error('dni',t('Falta la <b>letra</b> en el <b>DNI</b>.'));
  }else{
    $dni = str_repeat('0',9-strlen($dni)).$dni;
    //drupal_set_message(t('dni: !d',array('!d'=>$dni)));
    switch ($nie){
      case 'X':
        $dni = '0'.substr($dni,1,7);
        break;
      case 'Y':
        $dni = '1'.substr($dni,1,7);
        break;
      case 'Z':
        $dni = '0'.substr($dni,1,7);
        break;
    }
    //drupal_set_message(t('dni: @d',array('@d'=>$dni)));
    $resto = intval(substr($dni,0,8)) % 23;
    switch ($resto){
      case 0:
        if($l != 'T') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 1:
        if($l != 'R') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 2:
        if($l != 'W') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 3:
        if($l != 'A') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 4:
        if($l != 'G') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 5:
        if($l != 'M') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 6:
        if($l != 'Y') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 7:
        if($l != 'F') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 8:
        if($l != 'P') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 9:
        if($l != 'D') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 10:
        if($l != 'X') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 11:
        if($l != 'B') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 12:
        if($l != 'N') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 13:
        if($l != 'J') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 14:
        if($l != 'Z') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 15:
        if($l != 'S') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 16:
        if($l != 'Q') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 17:
        if($l != 'V') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 18:
        if($l != 'H') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 19:
        if($l != 'L') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 20:
        if($l != 'C') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 21:
        if($l != 'K') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
      case 22:
        if($l != 'E') form_set_error('dni',t('<b>DNI</b> incorrecto.'));
        break;
    }
  }
  $naf = $form_state['values']['naf'];
  if (!is_numeric($naf) || strlen($naf) < 10) form_set_error('naf',t('<b>Número Afiliación S.S.</b> incorrecto.'));
  $fecha = $form_state['values']['fecha'];
  
  //drupal_set_message(t('fecha @d-@m-@a',array('@d'=>date('d',strtotime($fecha)),'@m'=>date('m',strtotime($fecha)),'@a'=>date('Y',strtotime($fecha)))));
  if(strlen($fecha) < 10){
    form_set_error('fecha',t('<b>Fecha de Nacimiento</b> incorrecta.'));
  }elseif(!checkdate(date('m',strtotime($fecha)),date('d',strtotime($fecha)),date('Y',strtotime($fecha))))
    form_set_error('fecha',t('<b>Fecha de Nacimiento</b> incorrecta.'));
  $direccion =  $form_state['values']['direccion'];
  if (strlen($direccion) == 0) form_set_error('direccion',t('La <b>Dirección</b> está vacía.'));
  $poblacion =  $form_state['values']['poblacion'];
  if (strlen($poblacion) == 0) form_set_error('poblacion',t('La <b>Población</b> está vacía.'));
  $provincia =  $form_state['values']['provincia'];
  if (strlen($provincia) == 0) form_set_error('provincia',t('La <b>Provincia</b> está vacía.'));
  $cp =  $form_state['values']['cp'];
  if (!is_numeric($cp) || strlen($cp) < 5) form_set_error('cp',t('<b>Código Postal</b> incorrecto.'));
  $tfijo = str_replace(' ','',$form_state['values']['fijo']);
  if ((!is_numeric($tfijo) && strlen($tfijo)>0) || strlen($tfijo)<9 && strlen($tfijo)>0) form_set_error('fijo',t('<b>Tlfno. Fijo</b> incorrecto.'));
  $tmovil = str_replace(' ','',$form_state['values']['movil']);
  if ((!is_numeric($tmovil) && strlen($tmovil)>0) || strlen($tmovil)<9 && strlen($tmovil)>0) form_set_error('movil',t('<b>Tlfno. Móvil</b> incorrecto.'));
  $email = trim($form_state['values']['email']);
  if (!filter_var($email,FILTER_VALIDATE_EMAIL)) form_set_error('email',t('<b>Correo Electrónico</b> incorrecto.'));
  $iban = $form_state['values']['iban'];
  $entidad = $form_state['values']['ent'];
  $oficina = $form_state['values']['oficina'];
  $dc = $form_state['values']['dc'];
  $cuenta = $form_state['values']['cuenta'];
  $error = FALSE;

  if (strlen($iban) == 4){
    if (!is_string(substr($iban,0,2))){
      form_set_error('iban',t('El código <b>IBAN</b> es incorrecto'));
      $error = TRUE;
    } 
    if (!is_numeric(substr($iban,2,2))) {
      form_set_error('iban',t('El código <b>IBAN</b> es incorrecto'));
      $error = TRUE;
    }
  }else{
    form_set_error('iban',t('El código <b>IBAN</b> tiene que ser de 2 letras y 2 números'));
    $error = TRUE;
  }

  if (strlen($entidad) != 4 || !is_numeric($entidad)){
    form_set_error('ent',t('El código <b>Entidad</b> es incorrecto'));
    $error = TRUE;
  }
  if (strlen($oficina) != 4 || !is_numeric($oficina)){
    form_set_error('oficina',t('El código <b>Oficina</b> es incorrecto'));
    $error = TRUE;
  }
  if (strlen($dc) != 2 || !is_numeric($dc)) {
    form_set_error('dc',t('El código <b>DC</b> es incorrecto'));
    $error = TRUE;
  }
  if (strlen($cuenta) != 10 || !is_numeric($cuenta)) {
    form_set_error('cuenta',t('El código <b>Número de Cuenta</b> es incorrecto'));
    $error = TRUE;
  }
  if (!$error){
    $v = intval(substr($entidad,0,1))*4;
    $v += intval(substr($entidad,1,1))*8;
    $v += intval(substr($entidad,2,1))*5;
    $v += intval(substr($entidad,3,1))*10;
    
    $v += intval(substr($oficina,0,1))*9;
    $v += intval(substr($oficina,1,1))*7;
    $v += intval(substr($oficina,2,1))*3;
    $v += intval(substr($oficina,3,1))*6;
    
    $dc1 = 11-fmod($v,11);
    if($dc1 == 10) $dc1 = 1;
    if($dc1 == 11) $dc1 = 0;

    $v = intval(substr($cuenta,0,1))*1;
    $v += intval(substr($cuenta,1,1))*2;
    $v += intval(substr($cuenta,2,1))*4;
    $v += intval(substr($cuenta,3,1))*8;
    $v += intval(substr($cuenta,4,1))*5;
    $v += intval(substr($cuenta,5,1))*10;
    $v += intval(substr($cuenta,6,1))*9;
    $v += intval(substr($cuenta,7,1))*7;
    $v += intval(substr($cuenta,8,1))*3;
    $v += intval(substr($cuenta,9,1))*6;

    $dc2 = 11-fmod($v,11);
    if($dc2 == 10) $dc2 = 1;
    if($dc2 == 11) $dc2 = 0;
    //drupal_set_message(t('dc = @d',array('@d'=> $dc1.$dc2)));
    if ($dc != $dc1.$dc2){
      form_set_error('ent',t('Error general en cuenta'));
      form_set_error('oficina',t(''));
      form_set_error('dc',t(''));
      form_set_error('cuenta',t(''));
    }/*else{ 
      if(strtoupper(substr($iban,0,2)) == 'ES'){
        $v = ($entidad.$oficina.$dc.$cuenta.'142800' % 97);
        //$v = 98-(146512344612345678901428 % 97);
        drupal_set_message(t('cuenta = @d',array('@d'=> $entidad.$oficina.$dc.$cuenta.'142800')));
        drupal_set_message(t('dciban = @d',array('@d'=> $v)));
        $dciban = str_repeat('0',2-strlen($v)).$v;
        if(substr($iban,2,2) != $dciban) form_set_error('iban',t('Error en código <b>IBAN</b>'));
      }
    }*/
  }
  $irpf = $form_state['values']['irpf'];
  if ($irpf != ''){
    if (!is_numeric($irpf)){
      form_set_error('irpf',t('El <b>IRPF</b> tiene que ser numérico.'));
    }else{
      if (intval($irpf) < 6){
        form_set_error('irpf',t('El <b>IRPF</b> tiene que ser igual o mayor de <b>6</b>.'));
      }
      if (intval($irpf) > 50){
        form_set_error('irpf',t('El <b>IRPF</b> tiene que ser menor de 50.'));
      }
    }
  }
}

function _guardar_datos($form,&$form_state){
  global $user;
  $eid = $form_state['values']['id'];
  //$irpf = intval($form_state['values']['irpf']);
  $irpf = $form_state['values']['irpf'];
  $iban = strtoupper($form_state['values']['iban']);
  $ent = $form_state['values']['ent'];
  $oficina = $form_state['values']['oficina'];
  $dc = $form_state['values']['dc'];
  $cuenta = $form_state['values']['cuenta'];
  /*$f_baja = NULL;
  if($form_state['values']['fecha_baja'] != NULL){
    $f_baja = $form_state['values']['fecha_baja'];
  }*/
  $f_baja = NULL;
  if (isset($form_state['values']['fecha_baja'])) $f_baja = $form_state['values']['fecha_baja'];
  $query = db_select('empleados','e')
  ->fields('e',array('cc_iban','cc_entidad','cc_oficina','cc_dc','cc_cuenta','irpf'))
  ->condition('eid',$eid);
  $result=$query->execute();

  $irpf_actualizado = FALSE;
  $cc_actualizada = FALSE;
  if ($result->rowCount() > 0){
    foreach($result as $r){
      if($iban != $r->cc_iban ||
        $ent != $r->cc_entidad ||
        $oficina != $r->cc_oficina ||
        $dc != $r->cc_dc ||
        $cuenta != $r->cc_cuenta)
        $cc_actualizada = TRUE;
      if($irpf != intval($r->irpf)) $irpf_actualizado = TRUE;
    }
  }
  $query = db_select('empleados','e')
    ->fields('e',array('eid'))
    ->condition('eid',$eid);
  $result = $query->execute();
  if ($result->rowCount()>0){
    $query = db_update('empleados')
      ->fields(array(
        'nombre' => $form_state['values']['nombre'],
        'apellidos' => $form_state['values']['apellidos'],
        'dni' => $form_state['values']['dni'],
        'naf' => $form_state['values']['naf'],
        'f_nacimiento' => $form_state['values']['fecha'],
        'direccion' => strtoupper($form_state['values']['direccion']),
        'poblacion' => strtoupper($form_state['values']['poblacion']),
        'provincia' => strtoupper($form_state['values']['provincia']),
        'cp' => $form_state['values']['cp'],
        't_fijo' => $form_state['values']['fijo'],
        't_movil' => $form_state['values']['movil'],
        'estudios' => $form_state['values']['estudios'],
        'cc_iban' => $form_state['values']['iban'],
        'cc_entidad' => $form_state['values']['ent'],
        'cc_oficina' => $form_state['values']['oficina'],
        'cc_dc' => $form_state['values']['dc'],
        'cc_cuenta' => $form_state['values']['cuenta'],
        'irpf' => $form_state['values']['irpf'],
        'f_ultmodif' => date('Y-m-d'),
        'uid_modifdatos' => $user->uid,
        'f_baja' => $f_baja,
      ))
      ->condition('eid',$eid)
      ->execute();
  }else{
    $query = db_insert('empleados')
      ->fields(array(
        'eid' => $eid,
        'nombre' => $form_state['values']['nombre'],
        'apellidos' => $form_state['values']['apellidos'],
        'dni' => $form_state['values']['dni'],
        'naf' => $form_state['values']['naf'],
        'f_nacimiento' => $form_state['values']['fecha'],
        'direccion' => strtoupper($form_state['values']['direccion']),
        'poblacion' => strtoupper($form_state['values']['poblacion']),
        'provincia' => strtoupper($form_state['values']['provincia']),
        'cp' => $form_state['values']['cp'],
        't_fijo' => $form_state['values']['fijo'],
        't_movil' => $form_state['values']['movil'],
        'estudios' => $form_state['values']['estudios'],
        'cc_iban' => $form_state['values']['iban'],
        'cc_entidad' => $form_state['values']['ent'],
        'cc_oficina' => $form_state['values']['oficina'],
        'cc_dc' => $form_state['values']['dc'],
        'cc_cuenta' => $form_state['values']['cuenta'],
        'irpf' => $form_state['values']['irpf'],
        'f_altadatos' => date('Y-m-d'),
        'f_ultmodif' => date('Y-m-d'),
        'uid_modifdatos' => $user->uid,
        'f_baja' => $f_baja,
      ))
      ->execute();
  }
  if ($user->mail != $form_state['values']['email']){
    $query = db_update('users')
      ->fields(array('mail'=>$form_state['values']['email']))
      ->condition('uid',$eid)
      ->execute();
  }
  if (isset($form_state['values']['fecha_baja'])){
    $query = db_update('users')
    ->fields(array('status'=>0))
    ->condition('uid',$eid)
    ->execute();
    $query = db_update('simplenews_subscriber')
    ->fields(array('activated'=>0))
    ->condition('uid',$eid)
    ->execute();
  /*}else{
    $query = db_update('users')
    ->fields(array('status'=>1))
    ->condition('uid',$eid)
    ->execute();
    $query = db_update('simplenews_subscriber')
    ->fields(array('activated'=>1))
    ->condition('uid',$eid)
    ->execute();*/
  }

  if ($cc_actualizada){
    $query = db_select('empleados_config','e')
    ->fields('e',array('mail_cc'));
    $result=$query->execute();
    foreach($result as $r){
      $to = $r->mail_cc;
    }
    $u_empleado = user_load($eid);
    $mailto = str_replace(' ','',$to);
    $module = 'empleados';
    $key = 'cc_actualizada';
    $from = $u_empleado->mail;
    $language = language_default();
    $params = array(
      'eid' => $eid,
      'cc_iban' => $iban,
      'cc_entidad' => $ent,
      'cc_oficina' => $oficina,
      'cc_dc' => $dc,
      'cc_cuenta' => $cuenta
    );
    $send = TRUE;
    drupal_set_message(t('El número de Cuenta Corriente ha sido actualizado.'));
    $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
    if($result){
      drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
    }else{
      drupal_set_message(t('Error al avisar al administrador del cambio de Cuenta. Avise a la oficina para que tengan en cuenta el cambio.'),'error');
    }
  }
  if ($irpf_actualizado){
    $query = db_select('empleados_config','e')
      ->fields('e',array('mail_irpf'));
    $result=$query->execute();
    foreach($result as $r){
      $to = $r->mail_irpf;
    }
    $u_empleado = user_load($eid);
    //drupal_set_message(t('@m',array('@m'=>$u_empleado->mail)));
    $mailto = str_replace(' ','',$to);
    $module = 'empleados';
    $key = 'irpf_actualizado';
    $from = $u_empleado->mail;
    $language = language_default();
    $params = array(
      'eid' => $eid,
      'irpf' => $irpf,
    );
    $send = TRUE;
    drupal_set_message(t('El IRPF ha sido actualizado.'));
    $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
    if($result){
      drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
    }else{
      drupal_set_message(t('Error al avisar al administrador del cambio de IRPF. Avise a la oficina para que tengan en cuenta el cambio.'),'error');
    }
  }
  
}