<?php

function naf($form, &$form_state){
  global $user;
  global $base_path;
  $id_empleado = $user->uid;
  $name_empleado = $user->name;
  $u_admin = FALSE;
  $form = array();

  if (in_array('AdminEmpleados',$user->roles) || in_array('administrator',$user->roles)) $u_admin = TRUE;
  if (isset($_GET['empleado'])){
    if (!$u_empleado = user_load($_GET['empleado'])){
      drupal_set_message(t('Error en selección de Empleado.'),'error');
    }else{
      /*if (in_array('AdminEmpleados',$u_empleado->roles) && $user->uid != $u_empleado->uid){
        drupal_set_message(t('Empleado Seleccionado está Bloqueado, es Administrador'),'error');
      }else*/if (!$u_admin && $user->uid != $u_empleado->uid){
        //drupal_set_message(t('Sin acceso a otros usuarios.'),'error');
        $u_empleado = user_load($user->uid);
      }else{
        $id_empleado = $u_empleado->uid;
      }
    }
  }

  $empleado = obtenernombre($u_empleado->uid);
  $name_empleado = $empleado['usuario'];

  $menu = '<li><a href="'.$base_path.'empleados?empleado='.$id_empleado.'">Datos Personales</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/foto?empleado='.$id_empleado.'">Foto</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/dni?empleado='.$id_empleado.'">DNI</a></li>';
  $menu .='<li><a href="#">Tarjeta SS</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/pconducir?empleado='.$id_empleado.'">Permiso de Conducir</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/tach?empleado='.$id_empleado.'">Tarjeta Tacógrafo</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/cap?empleado='.$id_empleado.'">CAP</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certpuntos?empleado='.$id_empleado.'">Certificado de Puntos</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certsex?empleado='.$id_empleado.'">Certificado Delitos Sexuales</a></li>';
  $menu .='<li><b><a href="'.$base_path.'empleados/avisos?empleado='.$id_empleado.'&sort=desc&order=ENVIADO">AVISOS</a></b></li>';
  if (in_array('administrator',$user->roles))
    $menu .='<li><b><a href="'.$base_path.'empleados/config">CONFIG</a></b></li>';

  $form['menudocumentos'] = array(
    '#type' => 'item',
    '#markup' => '<ul class="tabs secondary clearfix">'.$menu.'</ul>',
    '#weight' => -50,
  );

  $form['datos'] = array(
    '#type' => 'fieldset',
    '#title' => 'Actualizar Afilización Seguridad Social',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );


  $form['datos']['id'] = array(
    '#type' => 'hidden',
    //'#markup' =>$id_empleado,
    '#value' => $id_empleado,
  );
  $form['datos']['name'] = array(
    '#type' => 'item',
    //'#markup' =>$id_empleado,
    '#markup' => 'Usuario: <b>'.$name_empleado.'</b>',
  );


  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
	ftp_pasv($conn_id, TRUE);
	$ficheros = ftp_nlist($conn_id, '');

  $fotoftp = $id_empleado.'_naf.jpg';
  $foto = $user->uid.substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 10).$id_empleado.'.jpg';
  //if (file_exists('private://'.$foto)) unlink('private://'.$foto);
  if (in_array($fotoftp,$ficheros)){
    $url_foto = $base_path.'sites/default/files/docs/'.$foto;
    //drupal_set_message(t('path: @p',array('@p'=>drupal_realpath('temporary://'.$foto))));
    ftp_get($conn_id, 'public://docs/'.$foto, $fotoftp, FTP_BINARY);

    $form['datos']['foto'] = array(
      '#type' => 'item',
      '#markup'=> '<a class="fancybox-effects-d" href="'.$url_foto.'" data-fancybox-group="NAF" title="NAF"><img src="'.$url_foto.'" alt="'.$id_empleado.'" title="NAF" style="max-width:350px;"></a>',
    );
    
  }
  ftp_close($conn_id);

  $form['datos']['file'] = array(
        '#type' => 'file',
        '#title' => t('Imagen:'),
        '#description' => 'Seleccione imagen.<br />Sólo se permiten formatos "<strong>.jpg</strong>"',
  );
  $form['datos']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Guardar Datos'),
  );
  return $form;
}

function naf_validate($form, &$form_state){
  $file = file_save_upload('file', array(
    'file_validate_extensions' => array('jpg'),
  ));
  if ($file) {
    if ($file = file_move($file, 'public://docs/up')) {
      $form_state['values']['file'] = $file;
    }
    else {
      form_set_error('file', t('Fallo al escribir el fichero en la carpeta site\'s.'));
    }
  }
  else {
    form_set_error('file', t('Fichero no actualizado.'));
  }
}

function naf_submit($form, &$form_state){
  global $user;
  $file=$form_state['values']['file'];
  unset($form_state['values']['file']);
  $file->status = FILE_STATUS_PERMANENT;
  file_save($file);
  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
  ftp_pasv($conn_id, TRUE);
  $fotoftp = $form_state['values']['id'].'_naf.jpg';
  ftp_put($conn_id, $fotoftp, $file->uri, FTP_BINARY);
  ftp_close($conn_id);

  $query = db_delete('file_managed')
    ->condition('uid',$user->uid)
    ->condition('filename',$file->filename)
    ->condition('status',1)
     ->execute();
  drupal_set_message(t('Imagen actualizada correctamente.'));

  $id_empleado = $form_state['values']['id'];
  $query = db_select('empleados_doc','e')
    ->fields('e', array('naf_actualiza'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  if ($result->rowCount() > 0){
    $query = db_update('empleados_doc')
      ->fields(array(
        'naf_uid_actualiza' => $user->uid,
        'naf_actualiza' => date('Y-m-d'),
      ))
      ->condition('eid',$id_empleado)
    ->execute();
  }else{
    $query = db_insert('empleados_doc')
      ->fields(array(
        'eid' => $id_empleado,
        'naf_uid_actualiza' => $user->uid,
        'naf_actualiza' => date('Y-m-d'),
      ))
    ->execute();
  }

  $query = db_select('empleados_config','e')
  ->fields('e',array('mail_cc'));
  $result=$query->execute();
  foreach($result as $r){
    $to = $r->mail_cc;
  }
  $mailto = str_replace(' ','',$to);
  $module = 'empleados';
  $key = 'naf_actualizado';
  $from = NULL;
  $language = language_default();
  $params = array(
    'imagen' => $file->filename,
    'eid' => $id_empleado,
  );
  $send = TRUE;
  $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
  if($result){
    drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
  }else{
    drupal_set_message(t('Error al avisar al administrador del cambio de NAF.'),'error');
  }

  unlink($file->uri);
}