<?php

function permiso_conducir($form, &$form_state){
  global $user;
  global $base_path;
  $id_empleado = $user->uid;
  $name_empleado = $user->name;
  $u_admin = FALSE;
  $form = array();

  if (in_array('AdminEmpleados',$user->roles) || in_array('administrator',$user->roles)) $u_admin = TRUE;
  if (isset($_GET['empleado'])){
    if (!$u_empleado = user_load($_GET['empleado'])){
      drupal_set_message(t('Error en selección de Empleado.'),'error');
    }else{
      /*if (in_array('AdminEmpleados',$u_empleado->roles) && $user->uid != $u_empleado->uid){
        drupal_set_message(t('Empleado Seleccionado está Bloqueado, es Administrador'),'error');
      }else*/if (!$u_admin && $user->uid != $u_empleado->uid){
        //drupal_set_message(t('Sin acceso a otros usuarios.'),'error');
        $u_empleado = user_load($user->uid);
      }else{
        $id_empleado = $u_empleado->uid;
      }
    }
  }

  $empleado = obtenernombre($u_empleado->uid);
  $name_empleado = $empleado['usuario'];

  $menu = '<li><a href="'.$base_path.'empleados?empleado='.$id_empleado.'">Datos Personales</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/foto?empleado='.$id_empleado.'">Foto</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/dni?empleado='.$id_empleado.'">DNI</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/naf?empleado='.$id_empleado.'">Tarjeta SS</a></li>';
  $menu .='<li><a href="#">Permiso de Conducir</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/tach?empleado='.$id_empleado.'">Tarjeta Tacógrafo</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/cap?empleado='.$id_empleado.'">CAP</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certpuntos?empleado='.$id_empleado.'">Certificado de Puntos</a></li>';
  $menu .='<li><a href="'.$base_path.'empleados/certsex?empleado='.$id_empleado.'">Certificado Delitos Sexuales</a></li>';
  $menu .='<li><b><a href="'.$base_path.'empleados/avisos?empleado='.$id_empleado.'&sort=desc&order=ENVIADO">AVISOS</a></b></li>';
  if (in_array('administrator',$user->roles))
    $menu .='<li><b><a href="'.$base_path.'empleados/config">CONFIG</a></b></li>';

  $form['menudocumentos'] = array(
    '#type' => 'item',
    '#markup' => '<ul class="tabs secondary clearfix">'.$menu.'</ul>',
    '#weight' => -50,
  );

  $form['datos'] = array(
    '#type' => 'fieldset',
    '#title' => 'Actualizar Permiso de Conducir',
    '#collapsible' => FALSE,
    '#collapsed' => FALSE,
  );

  $form['datos']['id'] = array(
    '#type' => 'hidden',
    //'#markup' =>$id_empleado,
    '#value' => $id_empleado,
  );

  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
	ftp_pasv($conn_id, TRUE);
	$ficheros = ftp_nlist($conn_id, '');
  
  $form['datos']['name'] = array(
    '#type' => 'item',
    //'#markup' =>$id_empleado,
    '#markup' => 'Usuario: <b>'.$name_empleado.'</b>',
  );

  $dniftp = $id_empleado.'_pconducirf.jpg';
  $dnif = $user->uid.substr(str_shuffle("-_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 10).$id_empleado.'.jpg';
  //if (file_exists('private://'.$foto)) unlink('private://'.$foto);
  if (in_array($dniftp,$ficheros)){
    $url_dnif = $base_path.'sites/default/files/docs/'.$dnif;
    //drupal_set_message(t('path: @p',array('@p'=>drupal_realpath('temporary://'.$foto))));
    ftp_get($conn_id, 'public://docs/'.$dnif, $dniftp, FTP_BINARY);

    $form['datos']['docf'] = array(
      '#type' => 'item',
      '#markup'=> '<a class="fancybox-effects-d" href="'.$url_dnif.'" data-fancybox-group="Pconducir" title="Permiso Conducir Frontal"><img src="'.$url_dnif.'" alt="'.$id_empleado.'" title="Permiso Conducir Frontal" style="max-width:350px;"></a>',
    );
  }


  $form['datos']['filef'] = array(
        '#type' => 'file',
        '#title' => t('Permiso Conducir cara Frontal:'),
        '#description' => 'Seleccione imagen.<br />Sólo se permiten formatos "<strong>.jpg</strong>"',
  );

  $dniftp = $id_empleado.'_pconducirt.jpg';
  $dnit = $user->uid.substr(str_shuffle("-_0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 10).$id_empleado.'.jpg';
  //if (file_exists('private://'.$foto)) unlink('private://'.$foto);
  if (in_array($dniftp,$ficheros)){
    $url_dnit = $base_path.'sites/default/files/docs/'.$dnit;
    //drupal_set_message(t('path: @p',array('@p'=>drupal_realpath('temporary://'.$foto))));
    ftp_get($conn_id, 'public://docs/'.$dnit, $dniftp, FTP_BINARY);

    $form['datos']['dnit'] = array(
      '#type' => 'item',
      '#markup'=> '<a class="fancybox-effects-d" href="'.$url_dnit.'" data-fancybox-group="Pconducir" title="Permiso Conducir Trasera"><img src="'.$url_dnit.'" alt="'.$id_empleado.'" title="Permiso Conducir Trasera" style="max-width:350px;"></a>',
    );
  }
  ftp_close($conn_id);

  $form['datos']['filet'] = array(
        '#type' => 'file',
        '#title' => t('Permiso Conducir cara Trasera:'),
        '#description' => 'Seleccione imagen.<br />Sólo se permiten formatos "<strong>.jpg</strong>"',
  );
  $query = db_select('empleados_doc','d')
    ->fields('d',array('pconducir_caduca','pconducir_actualiza','pconducir_uid_actualiza'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  $caduca = NULL;
  $actualiza = NULL;
  $u_actualiza = 0;
  foreach ($result as $q){
    $caduca = $q->pconducir_caduca;
    $actualiza = $q->pconducir_actualiza;
    $u_actualiza = $q->pconducir_uid_actualiza;
  }
  $format = 'd-m-Y';
  $form['datos']['fecha'] = array(
    '#type' => 'date_popup',
    '#title' => t('Validez Permiso Conducir "D":'),
    '#default_value' => $caduca, 
    '#date_format' => $format,
    '#size' => 12,
    '#date_label_position' => 'within',
    '#date_year_range' => '-0:+20',
    '#attributes'=> array('autocomplete' => 'off'),
  );
  if (isset($actualiza)){
    $form['datos']['ult_actualiza'] = array(
      '#type' => 'item',
      '#markup' =>'<p>Última actualización: <b>'.date('d-m-Y',strtotime($actualiza)).'</b></p>',
    );
  }

  $form['datos']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Guardar Datos'),
  );
  return $form;
}

function permiso_conducir_validate($form, &$form_state){
  $nofilef = false;
  $filef = file_save_upload('filef', array(
    'file_validate_extensions' => array('jpg'),
  ));
  if ($filef) {
    if ($filef = file_move($filef, 'public://docs/up')) {
      $form_state['values']['filef'] = $filef;
    }
    else {
      form_set_error('filef', t('Fallo al escribir el fichero en la carpeta site\'s.'));
    }
  }else{
    $nofilef = TRUE;
  }

  $nofilet = FALSE;
  $filet = file_save_upload('filet', array(
    'file_validate_extensions' => array('jpg'),
  ));
  if ($filet) {
    if ($filet = file_move($filet, 'public://docs/up')) {
      $form_state['values']['filet'] = $filet;
    }
    else {
      form_set_error('filet', t('Fallo al escribir el fichero en la carpeta site\'s.'));
    }
  }
  else {
    $nofilet = TRUE;
  }
  $valores = explode('-',$form_state['values']['fecha']);
  if(count($valores) != 3 || !checkdate($valores[1], $valores[2], $valores[0]))
    form_set_error('fecha',t('Campo <strong>Validez</strong> incorrecta.'));
  $id_empleado = $form_state['values']['id'];
  $query = db_select('empleados_doc','e')
    ->fields('e', array('pconducir_caduca'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();

  if ($result->rowCount() > 0){
    foreach($result as $r){
      $fecha = $r->pconducir_caduca;
    }
    if(strtotime($fecha) > strtotime($form_state['values']['fecha'])){
      form_set_error('fecha',t('La <strong>Validez</strong> es inferior a la fecha anterior.'));
      return;
    }
  }
  if(strtotime(date('Y-m-d 00:00:00')) > strtotime($form_state['values']['fecha'])){
    form_set_error('fecha',t('La <strong>Validez</strong> es inferior a HOY.'));
    return;
  }

/*  if ($nofilef && $nofilet){
    form_set_error('filef', 'Seleccione al menos una imagen');
    form_set_error('filet', '');
  }*/

}

function permiso_conducir_submit($form, &$form_state){
  global $user;
  $act_filef = FALSE;
  $act_filet = FALSE;
  $dnifname = '';
  $dnitname = '';
  $filef=$form_state['values']['filef'];
  if ($filef){
    unset($form_state['values']['filef']);
    $filef->status = FILE_STATUS_PERMANENT;
    file_save($filef);
    $act_filef = TRUE;
    $dnifname = $filef->filename;
  }
  $filet=$form_state['values']['filet'];
  if ($filet){
    unset($form_state['values']['filet']);
    $filet->status = FILE_STATUS_PERMANENT;
    file_save($filet);
    $act_filet = TRUE;
    $dnitname = $filet->filename;
  }
  $ftp_server = variable_get('emp_ftp_srv');
	$ftp_user_name =  variable_get('emp_ftp_usr');
	$ftp_user_pass =  variable_get('emp_ftp_pwd');
  $ftp_port = variable_get('emp_ftp_port');
	$conn_id = ftp_connect($ftp_server,$ftp_port); 
	
	// iniciar una sesi�n con nombre de usuario y contrase�a
	//set_time_limit(60);
	$login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 
	
	// verificar la conexi�n
	if ((!$conn_id) || (!$login_result)) {  
      drupal_set_message(t('Error al acceder al servidor de datos'),'error');
      ftp_close($conn_id);
	    return; 
	}
  ftp_pasv($conn_id, TRUE);
  if ($act_filef){
    $dniftp = $form_state['values']['id'].'_pconducirf.jpg';
    ftp_put($conn_id, $dniftp, $filef->uri, FTP_BINARY);
    $query = db_delete('file_managed')
    ->condition('uid',$user->uid)
    ->condition('filename',$filef->filename)
    ->condition('status',1)
    ->execute();
  }
  if ($act_filet){
    $dniftp = $form_state['values']['id'].'_pconducirt.jpg';
    ftp_put($conn_id, $dniftp, $filet->uri, FTP_BINARY);  ftp_close($conn_id);
    $query = db_delete('file_managed')
    ->condition('uid',$user->uid)
    ->condition('filename',$filet->filename)
    ->condition('status',1)
    ->execute();
  }
 
  if($act_filet && $act_filef){
    drupal_set_message(t('Imagenes actualizadas correctamente.'));
  }else{
    drupal_set_message(t('Imagen actualizada correctamente.'));
  }
  
  $id_empleado = $form_state['values']['id'];
  $query = db_select('empleados_doc','e')
    ->fields('e', array('pconducir_caduca'))
    ->condition('eid',$id_empleado);
  $result = $query->execute();
  if ($result->rowCount() > 0){
    $query = db_update('empleados_doc')
      ->fields(array(
        'pconducir_caduca' => date('Y-m-d',strtotime($form_state['values']['fecha'])),
        'pconducir_uid_actualiza' => $user->uid,
        'pconducir_actualiza' => date('Y-m-d'),
      ))
      ->condition('eid',$id_empleado)
    ->execute();
  }else{
    $query = db_insert('empleados_doc')
      ->fields(array(
        'eid' => $id_empleado,
        'pconducir_caduca' => date('Y-m-d',strtotime($form_state['values']['fecha'])),
        'pconducir_uid_actualiza' => $user->uid,
        'pconducir_actualiza' => date('Y-m-d'),
      ))
    ->execute();
  }
  $query = db_select('empleados_config','e')
  ->fields('e',array('mail_pconducir'));
  $result=$query->execute();
  foreach($result as $r){
    $to = $r->mail_pconducir;
  }
  $mailto = str_replace(' ','',$to);
  $module = 'empleados';
  $key = 'pc_actualizado';
  $from = NULL;
  $language = language_default();
  $params = array(
    'eid' => $id_empleado,
    'pcf' => $dnifname,
    'pct' => $dnitname,
    'pcfecha' => date('d-m-Y',strtotime($form_state['values']['fecha'])),
  );
  $send = TRUE;
  $result = drupal_mail($module, $key, $mailto, $language, $params, $from, $send);
  if($result){
    drupal_set_message(t('Se ha enviado un aviso al administrador para hacer efectivo el cambio.'));
  }else{
    drupal_set_message(t('Error al avisar al administrador del cambio del Permiso de concucir.'),'error');
  }
  if ($act_filef) unlink($filef->uri);
  if ($act_filet) unlink($filet->uri);
}